## R has a predefined dataset with the name "iris"
  # To know more about the dataset type "?iris" in the console

# 1) Creating Training and Testing data from "iris" dataset
  # 1.1) Generating Random Numbers
  set.seed(100)
  # 1.2) Creating sample for splitting dataset
  Sample <- sample(nrow(iris),0.7*nrow(iris))
  # 1.3) Training dataset containing 70% of data
  Training <- iris[Sample,]
  # 1.4) Testing dataset containing 30% of data
  Testing <- iris[-Sample,]
  
# 2) Normalizing data
  # 2.1) Normalizing training data
  Scaled_Training = Training
  Scaled_Training[,1:4] <- scale(Training[,1:4])
  # 2.2) Normalizing testing data
  Scaled_Testing = Testing
  Scaled_Testing[,1:4] <- scale(Testing[,1:4])
  
# 3) Labelling species
  # 3.1) Labelling species for training data
  Scaled_Training$Species <- as.integer(factor(Scaled_Training$Species))
  # 3.2) Labelling species for testing data
  Scaled_Testing$Species <- as.integer(factor(Scaled_Testing$Species))
  
# 4) Creating ANN and predicting values
  # 4.1) Fitting ANN
  # Run the following command after removing "#" if "neuralnet" library is not installed
  # install.packages("neuralnet")
  library(neuralnet)
  ANN = neuralnet(Species ~ Sepal.Length + Sepal.Width + Petal.Length + Petal.Width, Scaled_Training, hidden = 3, linear.output = T)
  # 4.2) Plotting ANN
  plot(ANN, rep = "best")
  
# 5) Predictions using ANN and plotting results
  predict = compute(ANN, Scaled_Testing[,c(1:4)])

# 6) Calculate Root Mean Square Error (RMSE)
  RMSE = (sum((as.numeric(predict$net.result - Scaled_Testing$Species))^2) / nrow(Scaled_Testing)) ^ 0.5
  paste0("Root Mean Square Error is ", RMSE)
  
# 7) Plotting actual values v/s predicted values
  plot(as.integer(factor(Testing$Species)),main = "Actual v/s Predicted Species",ylab = "",xlab = "",ylim = c(0.75,3.25))
  # 7.1) Adding a line to represent the predicted values
  lines(predict$net.result,lty=1)
  # 7.2) Clipping legend to the figure region instead of the plot region
  par(xpd=TRUE)
  # 7.3) Adding a legend
  legend("topleft",text.width = 7,legend=c("Actual","Predicted"),pch = c(1,NA) ,lty = c(NA,1) ,cex=0.8)
  # 7.4) Setting and adjusting labels of x and y axes
  title(ylab="Species",xlab="Index", line=2.25, cex.lab=1)